/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.util.LocalizableText;
import java.util.EventObject;

public class SingleStepEvent
extends EventObject {
    public static final int COMPLETION_SUCCESSFUL = 1;
    public static final int COMPLETION_UNSUCCESSFUL = 2;
    public static final int COMPLETION_CANCELED = 3;
    private int completionStatus;
    private LocalizableText message;
    private LocalizableText detailsMessage;
    private boolean cancelable;
    private int duration;

    public SingleStepEvent(UpdateUtilities source, LocalizableText message, int status) {
        super(source);
        this.setMessage(message);
        this.setDetailsMessage(null);
        this.setCompletionStatus(status);
        this.detailsMessage = null;
        this.duration = 0;
        this.cancelable = true;
    }

    public int getCompletionStatus() {
        return this.completionStatus;
    }

    public LocalizableText getMessage() {
        return this.message;
    }

    public LocalizableText getDetailsMessage() {
        return this.detailsMessage;
    }

    public boolean getCancelable() {
        return this.cancelable;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setCancelable(boolean newCancelState) {
        this.cancelable = newCancelState;
    }

    public void setDuration(int newDuration) {
        this.duration = newDuration;
    }

    public void setDetailsMessage(LocalizableText message) {
        this.detailsMessage = null == message ? new LocalizableText(BaseTextBundle.getBundleName(), "updates.sse.default.msg") : message;
    }

    private void setCompletionStatus(int status) {
        this.completionStatus = 1 == status || 2 == status || 3 == status ? status : 2;
    }

    private void setMessage(LocalizableText message) {
        this.message = null == message ? new LocalizableText(BaseTextBundle.getBundleName(), "updates.sse.default.msg") : message;
    }
}

